
; Heartbeat simulator

	ERRORLEVEL -302
	ERRORLEVEL -306

	    list      p=12F617        	; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


   __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON &_INTRC_OSC_NOCLKOUT & _IOSCFS_8MHZ &_WRT_OFF

; RAM 
COUNT_LS		equ	H'20'	; timeout counter ls byte
COUNT_MS		equ	H'21'	; timeout counter ms byte
MODE			equ	H'22'	; JP1 Mode position
STORE1			equ	H'23'	; delay counter	
STORE2			equ	H'24'	; delay counter
SWITCH			equ	H'25'	; switch flag
TEMP			equ	H'26'	; temporary
TEMP2			equ	H'27'
SECONDS		equ	H'28'	; for timeout, seconds counter
DIGITAL			equ	H'29'	; digital (A/D) value
MS_VAL		equ	H'2A'	; 1 millisecond delay random value
MS100_VAL		equ	H'2B'	; 100ms delay randomised value
RATE_ADJ		equ	H'2C'	; rate adjust for sampling
;
;	
; math files/ random generator 
BARGB0		equ	H'39'	; random number generator
BARGB1		equ	H'3A'	; random number generator
BARGB2		equ	H'3B'	; random number generator
AARGB0		equ	H'3C'	; random number gen
AARGB1		equ	H'3D'	; random number gen
AARGB2		equ	H'3E'	; random number gen
AARGB3		equ	H'3F'	; random number gen
AARGB4		equ	H'40'	; random number gen
AARGB5		equ	H'41'	; random number gen
AARGB6		equ	H'42'	; random number gen
RANDB0		equ	H'43'	; random number seed
RANDB1		equ	H'44'	; random number seed
RANDB2		equ	H'45'	; random number seed
RANDB3		equ	H'46'	; random number seed
TEMPB0		equ	H'47'	; random gen temp files
TEMPB1		equ	H'48'	; random gen temp files
TEMPB2		equ	H'49'	; random gen temp files
TEMPB3		equ	H'4A'	; random gen temp files
LOOPCOUNT	equ	H'4B'	; loop counter in random gen
REMB0			equ	H'4C'	; remainder
TEMP1			equ	H'4D'	; temporary
RNDM1			equ	H'4E'	; random value
RNDM2			equ	H'4F'	; random value
;
;
; DATA ( 4 blocks for writing/reading) data in the ls bytes only. Progtrammed from H0700 
TIMERms		equ	H'60'	; timer
TIMERls			equ	H'61'	; 
RATEms			equ	H'62'	; rate
RATEls			equ	H'63'
; reserve up to H'67'
; end 4-word block
;
;
; All banks RAM
W_TMP			equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 
DATA_ADD		equ	H'72'	; Load initial data address when writing to memory
READADDMS	equ	H'73'	; flash memory read address ms byte making up a 14 bit byte (ms byte has 6 bits)
READADDLS	equ	H'74'  	; flash memory read address ls byte (ls byte has 8 bits)
;___________________________________________________________
; initial values
	org	H'300'		; heartbeat table 1ms sample
   
	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84
	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F83, 0x3F84, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F82, 0x3F82, 0x3F81, 0x3F81
 	DW 0x3F81, 0x3F81, 0x3F82, 0x3F83, 0x3F85, 0x3F86, 0x3F87, 0x3F88, 0x3F88, 0x3F87, 0x3F86, 0x3F84, 0x3F83, 0x3F82, 0x3F81, 0x3F80
	DW 0x3F80, 0x3F80, 0x3F81, 0x3F82, 0x3F83, 0x3F84, 0x3F85, 0x3F86, 0x3F87, 0x3F87, 0x3F87, 0x3F86, 0x3F85, 0x3F84, 0x3F84, 0x3F83
 	DW 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F82, 0x3F82, 0x3F83, 0x3F82, 0x3F83, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F85
	DW 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F82, 0x3F82, 0x3F81
 	DW 0x3F81, 0x3F82, 0x3F82, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F82, 0x3F81, 0x3F80, 0x3F7F
	DW 0x3F80, 0x3F81, 0x3F83, 0x3F84, 0x3F86, 0x3F87, 0x3F88, 0x3F88, 0x3F88, 0x3F88, 0x3F87, 0x3F85, 0x3F84, 0x3F82, 0x3F81, 0x3F80
 	DW 0x3F80, 0x3F80, 0x3F81, 0x3F81, 0x3F82, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F82, 0x3F82, 0x3F82
 	DW 0x3F82, 0x3F83, 0x3F83, 0x3F84, 0x3F86, 0x3F87, 0x3F88, 0x3F89, 0x3F89, 0x3F89, 0x3F88, 0x3F86, 0x3F84, 0x3F81, 0x3F7E, 0x3F7B
 	DW 0x3F79, 0x3F78, 0x3F78, 0x3F7A, 0x3F7D, 0x3F81, 0x3F84, 0x3F85, 0x3F86, 0x3F88, 0x3F8A, 0x3F8A, 0x3F88, 0x3F84, 0x3F81, 0x3F82
	DW 0x3F86, 0x3F8F, 0x3F9B, 0x3FA8, 0x3FAF, 0x3FAB, 0x3F9D, 0x3F8A, 0x3F73, 0x3F58, 0x3F38, 0x3F21, 0x3F21, 0x3F3B, 0x3F5E, 0x3F7D
 	DW 0x3F97, 0x3FB0, 0x3FCC, 0x3FE5, 0x3FEE, 0x3FE1, 0x3FC6, 0x3FA6, 0x3F89, 0x3F71, 0x3F62, 0x3F5D, 0x3F62, 0x3F6B, 0x3F74, 0x3F77
 	DW 0x3F73, 0x3F69, 0x3F58, 0x3F45, 0x3F3B, 0x3F40, 0x3F52, 0x3F6A, 0x3F80, 0x3F91, 0x3F9E, 0x3FA8, 0x3FB3, 0x3FC2, 0x3FDB, 0x3FF2
 	DW 0x3FF7, 0x3FDE, 0x3FB7, 0x3F92, 0x3F78, 0x3F68, 0x3F5D, 0x3F4F, 0x3F38, 0x3F1B, 0x3F0A, 0x3F14, 0x3F33, 0x3F58, 0x3F76, 0x3F8D
 	DW 0x3F9E, 0x3FAD, 0x3FBE, 0x3FCF, 0x3FDB, 0x3FDC, 0x3FD1, 0x3FBD, 0x3FA5, 0x3F8F, 0x3F7C, 0x3F6D, 0x3F61, 0x3F57, 0x3F51, 0x3F4E
	DW 0x3F4F, 0x3F54, 0x3F5B, 0x3F65, 0x3F6F, 0x3F7A, 0x3F84, 0x3F8D, 0x3F95, 0x3F9B, 0x3F9F, 0x3FA0, 0x3F9E, 0x3F9A, 0x3F95, 0x3F8E
 	DW 0x3F87, 0x3F81, 0x3F7B, 0x3F78, 0x3F75, 0x3F75, 0x3F76, 0x3F78, 0x3F7B, 0x3F7E, 0x3F81, 0x3F83, 0x3F85, 0x3F86, 0x3F87, 0x3F88
 	DW 0x3F88, 0x3F89, 0x3F88, 0x3F87, 0x3F86, 0x3F83, 0x3F80, 0x3F7E, 0x3F7C, 0x3F7B, 0x3F7A, 0x3F7B, 0x3F7D, 0x3F7F, 0x3F81, 0x3F83
 	DW 0x3F84, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F84, 0x3F85, 0x3F85, 0x3F86, 0x3F86, 0x3F87, 0x3F87, 0x3F86, 0x3F85, 0x3F83, 0x3F82
 	DW 0x3F81, 0x3F81, 0x3F81, 0x3F82, 0x3F83, 0x3F84, 0x3F85, 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F82, 0x3F81, 0x3F81, 0x3F82, 0x3F83
 	DW 0x3F84, 0x3F85, 0x3F86, 0x3F87, 0x3F87, 0x3F87, 0x3F86, 0x3F85, 0x3F84, 0x3F82, 0x3F81, 0x3F81, 0x3F81, 0x3F81, 0x3F82, 0x3F83
 	DW 0x3F84, 0x3F85, 0x3F85, 0x3F86, 0x3F86, 0x3F86, 0x3F85, 0x3F84, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F86, 0x3F87
 	DW 0x3F88, 0x3F88, 0x3F87, 0x3F85, 0x3F83, 0x3F80, 0x3F7E, 0x3F7D, 0x3F7D, 0x3F7E, 0x3F7F, 0x3F81, 0x3F84, 0x3F85, 0x3F88, 0x3F89
 	DW 0x3F8B, 0x3F8C, 0x3F8C, 0x3F8B, 0x3F89, 0x3F87, 0x3F85, 0x3F83, 0x3F81, 0x3F7F, 0x3F7E, 0x3F7E, 0x3F7E, 0x3F7F, 0x3F80, 0x3F82
 	DW 0x3F84, 0x3F85, 0x3F86, 0x3F87, 0x3F87, 0x3F88, 0x3F87, 0x3F87, 0x3F86, 0x3F85, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83
 	DW 0x3F83, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F83
 	DW 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F84, 0x3F83, 0x3F83, 0x3F82, 0x3F81, 0x3F81
 	DW 0x3F81, 0x3F82, 0x3F82, 0x3F83, 0x3F84, 0x3F85, 0x3F86, 0x3F86, 0x3F86, 0x3F85, 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F82
 	DW 0x3F82, 0x3F81, 0x3F82, 0x3F82, 0x3F82, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F85
 	DW 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F82, 0x3F7F, 0x3F7D, 0x3F7F, 0x3F83, 0x3F86, 0x3F87, 0x3F87, 0x3F8A, 0x3F91, 0x3F99, 0x3F99
 	DW 0x3F8F, 0x3F7D, 0x3F6A, 0x3F5A, 0x3F54, 0x3F58, 0x3F65, 0x3F75, 0x3F86, 0x3F96, 0x3FA5, 0x3FB1, 0x3FBA, 0x3FBE, 0x3FB9, 0x3FAC
	DW 0x3F99, 0x3F86, 0x3F74, 0x3F63, 0x3F55, 0x3F4B, 0x3F48, 0x3F4C, 0x3F56, 0x3F64, 0x3F73, 0x3F82, 0x3F8F, 0x3F9A, 0x3FA3, 0x3FA9
 	DW 0x3FAD, 0x3FAF, 0x3FAE, 0x3FAA, 0x3FA3, 0x3F9A, 0x3F90, 0x3F86, 0x3F7C, 0x3F72, 0x3F69, 0x3F61, 0x3F5A, 0x3F56, 0x3F57, 0x3F5D
 	DW 0x3F66, 0x3F71, 0x3F7E, 0x3F8A, 0x3F95, 0x3F9F, 0x3FA6, 0x3FAA, 0x3FAA, 0x3FA6, 0x3F9F, 0x3F95, 0x3F8A, 0x3F7F, 0x3F75, 0x3F6C
	DW 0x3F66, 0x3F64, 0x3F65, 0x3F68, 0x3F6E, 0x3F76, 0x3F7D, 0x3F85, 0x3F8C, 0x3F91, 0x3F95, 0x3F97, 0x3F97, 0x3F95, 0x3F92, 0x3F8D
	DW 0x3F88, 0x3F83, 0x3F7E, 0x3F7B, 0x3F78, 0x3F76, 0x3F76, 0x3F76, 0x3F77, 0x3F7A, 0x3F7C, 0x3F7F, 0x3F82, 0x3F85, 0x3F87, 0x3F89
 	DW 0x3F8A, 0x3F8A, 0x3F8A, 0x3F89, 0x3F88, 0x3F86, 0x3F84, 0x3F82, 0x3F81, 0x3F83, 0x3F84, 0x3F85, 0x3F86, 0x3F86, 0x3F86, 0x3F86
 	DW 0x3F86, 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F82, 0x3F82, 0x3F82, 0x3F82, 0x3F83, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84
 	DW 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F84, 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F82, 0x3F83
 	DW 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F84, 0x3F84, 0x3F84, 0x3F83, 0x3F82, 0x3F82, 0x3F82
 	DW 0x3F82, 0x3F83, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F86, 0x3F86, 0x3F85, 0x3F85, 0x3F84, 0x3F84, 0x3F83, 0x3F83
 	DW 0x3F83, 0x3F83, 0x3F83, 0x3F83, 0x3F82, 0x3F82, 0x3F83, 0x3F83, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F85, 0x3F85, 0x3F84, 0x3F84

 		
	org	H'700'		; start address of where data memory is stored 
					DW H'3F7F' ; up to 8h timer
					DW H'3F22' ; heartrate
					DW H'3FFF' ; unused bytes set at erased level
					DW H'3FFF'
; ******************************************************************

; start at memory 0

	org		0				; reset vector
	goto	MAIN
; interrupt vector
	org		4
INTERRUPT
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0

; clear timer0 flag 
	bcf		PIR1,TMR1IF
	bcf		T1CON,0		; stop timer
; load timer 1 with 10,604 (H296C) so it counts 54,932 of 4us/count for overall 219.73ms 
	movlw	H'29'
	movwf	TMR1H
	movlw	H'6C'
	movwf	TMR1L
	bsf		T1CON,0		; restart timer

; 56.3s over 256 counts
	decfsz	SECONDS,f		; over every 256 counts
	goto	RECLAIM
; 56.25s
; COUNT_MS,LS using 512 (VR1 value A/D x 2) for 28,800s or 8 hours max
; decrease counter, but check if both zero first 

; if both are zero switch off amplifier
	movf	COUNT_LS,w
	btfss	STATUS,Z
	goto	REDUCE
	movf	COUNT_MS,w
	btfsc	STATUS,Z
;both zero
	goto	OFF

REDUCE
	movf	COUNT_LS,f
	btfss	STATUS,Z
	goto	REDLS				; if not zero then bypass ms byte
; if ls byte is zero, check if ms byte is zero
	movf	COUNT_MS,w
	btfsc	STATUS,Z		; if zero then end
	goto	OFF
	decf	COUNT_MS,f	; decrease counter ms byte
REDLS; reduce ls byte
	decf	COUNT_LS,f
	goto	RECLAIM
OFF

	bcf		GPIO,5			; VR1 off
	bcf		GPIO,0			; amp off
; check JP1, to ensure current is not drawn via this input/output
; set GP1 as a low output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; low output
	bcf		GPIO,1
	call		DELAYms		; 5ms
; make GPIO,1 an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; wait
	call		DELAYms
; if input is high, then JP1 in position 1 (pulled high)
	btfsc	GPIO,1 
	goto  	STOP			; can leave as is as no current drawn
; input is low, so JP1 could be in position 2 or input is floating
;test again
; set GP1 as a high output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; high output
	bsf		GPIO,1
	call		DELAYms		; 5ms
; make GPIO,1 an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; wait
	call		DELAYms
; if input is low, then JP1 is in position 2 (pulling low)
	btfss	GPIO,1
	goto	STOP
; otherwise is floating so make GP1 an output
; set GP1 as a high output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; ensure PWM is low
STOP
	movlw	D'00'			; zero for off 
	movwf	CCPR1L		; ms byte of PWM
	bcf		CCP1CON,5
	bcf		CCP1CON,4	
	sleep

; end of interrupt reclaim w and status 
RECLAIM
	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf  	W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt

; ***********************************************************
		
MAIN
;  set oscillator calibration
	bsf		STATUS,RP0     	; bank 1
        movlw   D'0'     			 ; set oscillator to factory calibrated frequency 
        movwf   OSCTUNE
	bcf		STATUS,RP0
SETUP
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'		; pullups off/on
	movwf	WPU
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'00000000'		; settings (pullups) prescaler/2
	movwf	OPTION_REG
; analog inputs, A/D
	movlw	B'00101000'
	movwf	ANSEL			; digital I/O and analog at AN3
	bcf		STATUS,RP0	; select memory bank 0
; bits 4-2. Select channel 3
; 011 = Channel 03 (AN3)
	movlw	B'00001100'		; channel 3, left justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on

; pwm set
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'63'			; 
	movwf	PR2				; PWM period register for 31.25kHz. 
	bcf		STATUS,RP0	; memory bank 0

; process PWM for 8bits resolution
	clrf		TEMP2
	movlw	H'4C'			; Set at resting quiescent for heartbeat
	movwf	TEMP
; shift for 6-bits in CCPR1L and ls bits in CCP1CON
	bcf		STATUS,C
	rrf		TEMP,f
	rrf		TEMP2,f
	rrf		TEMP,f
	rrf		TEMP2,f
	movf	TEMP,w
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00000000'		; prescaler /1 
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'		; set PWM mode
	movwf	CCP1CON		; enable PWM operation
	btfsc	TEMP2,7
	bsf		CCP1CON,5
	btfsc	TEMP2,6
	bsf		CCP1CON,4	

;Timer1 on
	movlw 	B'00110001'		; divide by 8 for 4us per count
	movwf	T1CON

; initial values
	clrf		SECONDS	; timer

; initial values for delay routines
	movlw	D'52'
	movwf	MS_VAL	; 1ms delay
	movlw	D'213'
	movwf	MS100_VAL	; 100ms delay
;......................................................................................................................................
; start by reading JP1

; set GP1 as a low output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; low output
	bcf		GPIO,1
	call		DELAYms		; 1ms
; make GPIO,1 an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; wait
	call		DELAYms
; if input is high, then JP1 in position 1 (pulled high)
	btfsc	GPIO,1 
	goto  	ONE
; input is low, so JP1 could be in position 2 or input is floating (3)
;test again
; set GP1 as a high output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; high output
	bsf		GPIO,1
	call		DELAYms		; 1ms
; make GPIO,1 an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011010'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; wait
	call		DELAYms
; if input is low, then JP1 is in position 2 (pulling low)
	btfss	GPIO,1
	goto	TWO
; otherwise is floating so make GP1 an output
; set GP1 as a high output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
; mode 3
	movlw	D'3'
	goto	MODE_No
ONE
	movlw	D'1'
	goto	MODE_No
TWO
	movlw	D'2'
MODE_No
	movwf	MODE	
;..........................................................................................................................................
; Start by a read of stored data

	movlw	H'07'			; ms address byte (H0700 start)
	movwf	READADDMS 
	movlw	H'00'
	movwf	READADDLS	; ls address byte

	call		READ			; 'w' has data for ls byte of timer
	movwf	TIMERls

	incf		READADDLS,f	; next ls address byte
	call		READ			; 'w' has data for ls byte of rate
	movwf	RATEls

; now check VR1
	bsf		GPIO,5			; VR1 on
	call		DELAYms
	call		ACQUIRE_AD	; read VR1


; check MODE
	movf	MODE,w
	xorlw	D'1'
	btfss	STATUS,Z		; when =1 then compare against timer value	
	goto	RATE_CK

	movf	ADRESH,w
	movwf	DIGITAL
	comf	DIGITAL,f		;  reverse as anticlockwise for trim pot is plus, clockwise is to GND
; remove ls bit for comparisons
	bcf		STATUS,C
	rrf		DIGITAL,w
	movwf	TEMP			; temporary 
	bcf		STATUS,C
	rrf		TIMERls,w
	xorwf	TEMP,w
	btfsc	STATUS,Z		; if the same do not write
	goto	BY_WRITE

	movf	DIGITAL,w		;
	movwf	TIMERls			; timer value

	goto	WRI_VAL


RATE_CK
	movf	MODE,w
	xorlw	D'2'
	btfss	STATUS,Z		; when =2 then compare against rate value	
	goto	BY_WRITE
	
	movf	ADRESH,w
	movwf	DIGITAL
	
; remove ls bit for comparisons
	bcf		STATUS,C
	rrf		DIGITAL,w
	movwf	TEMP			; temporary 
	bcf		STATUS,C
	rrf		RATEls,w
	xorwf	TEMP,w
	btfsc	STATUS,Z		; if the same do not write
	goto	BY_WRITE

	movf	DIGITAL,w
	movwf	RATEls			; rate value

WRI_VAL
; write timer value
	movlw	H'07'			; ms address byte (H0700 start)
	movwf	READADDMS 
	movlw	H'00'
	movwf	READADDLS	; ls address byte

	movlw	H'3F'			; ms byte set at erased level
	movwf	TIMERms
	movwf	RATEms

	movlw	TIMERms		; start of data address	; timer
	movwf	DATA_ADD
	call		WRITE

BY_WRITE

; load timer
	movf	TIMERls,w		; make sure it is not zero
	movlw	D'1'				; ready with a 1
	btfsc	STATUS,Z
	movwf	TIMERls			; place 1 in TIMERls when originally a zero

; multiply by 2 for overall 8h timeout maximum 2m minimum
	clrf		COUNT_MS
; remarked out for 4 hours max
;	bcf		STATUS,C
;	rlf		TIMERls,w
;	movwf	COUNT_LS
;	btfsc	STATUS,C		; when carry is set set bit 0 in ms byte
;	bsf		COUNT_MS,0
; counter now can switch off after timeout
	
; Interrupts
; enable interrupts

	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1, TMR1IE	; timer 1 enable interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bsf		INTCON,PEIE	; peripheral interrupts enable
	bcf		PIR1,TMR1IF		; flag for timer1 overflow	
	bsf 		INTCON,GIE		; set global interrupt enable 

; amplifier on
	bsf		GPIO,0			; amp on

HB; heart beat

; check VR1 if MODE=2 (rate). compare A/D with RATE. When different, write value.
	movf	MODE,w
	xorlw	D'2'
	btfss	STATUS,Z		; when =2 then compare against rate value	
	goto	BY_CHECK
; now check VR1
	bsf		GPIO,5			; VR1 on
	call		DELAYms
	call		ACQUIRE_AD	; read VR1
	movf	ADRESH,w
	movwf	DIGITAL
; remove ls bit for comparisons
	bcf		STATUS,C
	rrf		DIGITAL,w
	movwf	TEMP			; temporary 
	
	bcf		STATUS,C
	rrf		RATEls,w
	xorwf	TEMP,w
	btfsc	STATUS,Z		; if the same do not write
	goto	BY_CHECK
	movf	DIGITAL,w
	movwf	RATEls			; rate value

; write timer value
	movlw	H'07'			; ms address byte (H0700 start)
	movwf	READADDMS 
	movlw	H'00'
	movwf	READADDLS	; ls address byte

	movlw	H'3F'			; ms byte set at erased level
	movwf	TIMERms
	movwf	RATEms

	movlw	TIMERms		; start of data address	; timer
	movwf	DATA_ADD
	call		WRITE
BY_CHECK


; produce heartbeat at RATE set (RATEls)
; PWM values in flash memory 
	movlw	H'03'			; ms address byte (H0300 start)
	movwf	READADDMS 
	movlw	H'64'
	movwf	READADDLS	; ls address byte
HB1; produce heartbeat
	call		READ			; 'w' has data 
	movwf	TEMP			; store
	call		PROCESS		; place in PWM
	call		DELAYms

; next value

	incf		READADDLS,f
	btfsc	STATUS,Z		; if zero then increase ms byte
	incf		READADDMS,f

;
; compare with H'04F4' for end of first beat
	movf	READADDMS,w
	xorlw	H'04'
	btfss	STATUS,Z
	goto	HB1
	movf	READADDLS,w
	sublw	H'F4'
	btfsc	STATUS,C
	goto	HB1			

; delay based on heart beat RATE value

	movf	RATEls,w
	btfsc	STATUS,Z
	goto	NEXT_BEAT		; bypass rate extension when rate is zero
	movf	RATEls,w
	movwf	TEMP
EXTRA1
	movlw	D'3'
	call		DY2				; delay 
	decfsz	TEMP,f
	goto	EXTRA1


NEXT_BEAT
	movlw	H'05'			; ms address byte (H0300 start)
	movwf	READADDMS 
	movlw	H'45'
	movwf	READADDLS	; ls address byte
HB2
	call		READ			; 'w' has data 
	movwf	TEMP			; store
	call		PROCESS		; place in PWM
	call		DELAYms

	incf		READADDLS,f
	btfsc	STATUS,Z		; if zero then increase ms byte
	incf		READADDMS,f

; compare with H'0613' for end of heart beat
	movf	READADDMS,w
	xorlw	H'06'
	btfss	STATUS,Z
	goto	HB2
	movf	READADDLS,w
	sublw	H'13'
	btfsc	STATUS,C
	goto	HB2

; delay based on heart beat RATE value

	movf	RATEls,w
	btfsc	STATUS,Z
	goto	RNDM			; bypass rate extension when rate is zero
	movf	RATEls,w
	movwf	TEMP
EXTRA
	movlw	D'30'
	call		DY				; delay 
	decfsz	TEMP,f
	goto	EXTRA

RNDM ; randomise heartbeat frequency and rate

	call		RAND32			; random number
; initial values

	movf	RNDM1,w
	btfsc	STATUS,Z		; when zero update random	
	goto	UPDTE
	decfsz	RNDM1,f		; randomise randomly
	goto	HB

UPDTE
; adjust with rate
; divide by 32
	swapf	RATEls,w
	andlw	B'00001111'		; effectively a divide by 16
	movwf	RATE_ADJ
	bcf		STATUS,C
	rrf		RATE_ADJ,w	; overall divide by 32
		
	addlw	D'44'			; range of 44 to 52 adjusts for rate setting

	movwf	MS_VAL		; 1ms delay
	movlw	D'213'
	movwf	MS100_VAL		; 100ms delay

;	goto	HB					; bypasses random
	
	movf	AARGB3,w
	andlw	B'00000011'
	movwf	RNDM1

	movf	AARGB2,w		; random delay
	movwf	RNDM2
; set range for frequency say 10% 
	movwf	TEMP
	btfss	TEMP,7			; add or subtract
	goto	ADD1
	andlw	B'00000011'		; only use ls bits
	subwf	MS_VAL,f
	goto	RTE
ADD1
	movf	TEMP,w
	andlw	B'00000011'		; only use ls bits
	addwf	MS_VAL,f

RTE
	
; set rate at say 15%	

	movf	RNDM2,w		; random delay

; set range for frequency say 10% 
	movwf	TEMP
	btfss	TEMP,7			; add or subtract
	goto	ADD2
	andlw	B'00001111'		; only use ls bits
	subwf	MS100_VAL,f
	goto	HB				; repeat heartbeat
ADD2
	movf	TEMP,w
	andlw	B'00001111'		; only use ls bits
	addwf	MS100_VAL,f

	goto	HB				; repeat  heartbeat

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;.......................................................................................................................
; processing for PWM
PROCESS
; requires TEMP to have 8-bit value
	clrf		TEMP2

; process into CCPR1L and CCP1CON (8-bit resolution PWM)
; 8-bit value
; shift for ms 6-bits in CCPR1L and ls 2-bits in CCP1CON
	bcf		STATUS,C		; clear carry
	rrf		TEMP,f
	rrf		TEMP2,f			; carry into temp2
	rrf		TEMP,f
	rrf		TEMP2,f

; check timer 2 count
WAIT_READY
	movf	TMR2,w
	sublw	D'20'
	btfss	STATUS,C
	goto	WAIT_READY
; only transfer when timer has just reset
	movf	TEMP,w
	movwf	CCPR1L		; ms byte of PWM
	bcf		CCP1CON,4		; clear ls bits first
	bcf		CCP1CON,5
	btfsc	TEMP2,7
	bsf		CCP1CON,5		; set when required
	btfsc	TEMP2,6
	bsf		CCP1CON,4	
	return
; end processing for PWM

;..................................................................................
	
; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		GPIO,5		; VR1 off 
	return
;

; delay loop 
DELAYms; approx 1ms
	movlw	D'13'		; delay value
DY	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movf	MS_VAL,w
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

; delay loop 
DELAY100 ; approx 100ms
	movlw	D'255'		; delay value
DY2
	movwf	STORE1		; STORE1 is number of loops value
LOOP800	
	movf	MS100_VAL,w
	movwf	STORE2		; STORE2 is internal loop value	
LOOP900
	decfsz	STORE2,f
	goto	LOOP900
	decfsz	STORE1,f
	goto	LOOP800
	return
;........................................

; read data memory
READ; 'w' has read data
	bsf		STATUS,RP0	; select memory bank 1 
	movf	READADDMS,w 
	movwf 	PMADRH		; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 		; ls Byte of Program Address to read

	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
;	movf	PMDATH,w 		; ms Byte of Program data 

	movf	PMDATL,w 		; ls Byte of Program data
	bcf		STATUS,RP0	; bank 0
	return
;.............................................

; write to data memory
WRITE
	bcf		 INTCON,GIE 	; Disable interrupts 
G	btfsc	 INTCON,GIE		 ; See AN576
	goto	 G

	bsf		STATUS,RP0	; select memory bank 1
	movf	READADDMS,w 
	movwf 	PMADRH		; MS Byte of Program Address to write
	movf	READADDLS,w 
	movwf 	PMADRL 		; LS Byte of Program Address to write

	movf	DATA_ADD,w	; Load initial data address (must have start at a 16byte boundary) 
	movwf	FSR 
LOOP_WRITE 
	movf	 INDF,w 			; Load first data byte into upper byte
	movwf	 PMDATH		;
	incf		 FSR,f 			; Next byte
	movf	 INDF,w 			; Load second data byte into lower byte
	movwf	 PMDATL 		; 		
	incf		 FSR,f 			;
	bsf		 PMCON1,WREN ; Enable writes

; Required Sequence
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2		; Write 55h
	movlw	H'AA'		 	;
	movwf	PMCON2 		; Write AAh
	bsf		PMCON1,WR 	; Set WR bit to begin write
	nop					 	; NOPs required for time to transfer data to the buffer registers
	nop						; 
;
	bcf		PMCON1,WREN ; Disable writes
	movf	PMADRL,w
	incf		PMADRL,f		; Increment address
; select 4,8,12 or16 	
	; 0F = 16 words
	; 0B = 12 words
	; 07 =  8 words
	; 03 =  4 words
	andlw	H'03'			; Indicates when the set number of words have been programmed
	sublw	H'03'

	btfss	STATUS,Z 		; Exit on a match,
	goto	LOOP_WRITE	; Continue until ended
	bcf		STATUS,RP0	; bank 0
	bsf		 INTCON,GIE 	; enable interrupts 
	return


; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Use:	CALL	RAND32

;	Output:	32 bit random integer in AARGB0, AARGB1, AARGB2, AARGB3

;	Result:	AARG  <--  RAND32( AARG )

;	

;		min	max	mean
;	Timing:	487	487	487	clks



;	Linear congruential random number generator

;		X <- (a * X + c) mod m

;	The calculation is performed exactly, with multiplier a, increment c, and
;	modulus m, selected to achieve high ratings from standard spectral tests.

RAND32
		MOVF		RANDB0,W
		MOVWF		AARGB0
		MOVF		RANDB1,W
		MOVWF		AARGB1
		MOVF		RANDB2,W
		MOVWF		AARGB2
		MOVF		RANDB3,W
		MOVWF		AARGB3

		MOVLW		0x0D			; multiplier a = 1664525
		MOVWF		BARGB2
		MOVLW		0x66
		MOVWF		BARGB1
		MOVLW		0x19
		MOVWF		BARGB0

		CALL		FXM3224U

                INCF            AARGB6,F		; c = 1
                BTFSC           STATUS,Z
                INCF            AARGB5,F
		BTFSC		STATUS,Z
		INCF		AARGB4,F
		BTFSC		STATUS,Z
		INCF		AARGB3,F
		BTFSC           STATUS,Z
                INCF            AARGB2,F
		BTFSC		STATUS,Z
		INCF		AARGB1,F
		BTFSC		STATUS,Z
		INCF		AARGB0,F

		MOVF		AARGB3,W
		MOVWF		RANDB0			; m = 2**32
		MOVF		AARGB4,W
		MOVWF		RANDB1
		MOVF		AARGB5,W
		MOVWF		RANDB2
		MOVF		AARGB6,W
		MOVWF		RANDB3

		RETLW		0x00

;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
                CLRF    AARGB4          ; clear partial product
                CLRF    AARGB5
                CLRF    AARGB6
                MOVF   AARGB0,W
                MOVWF   TEMPB0
                MOVF   AARGB1,W
                MOVWF   TEMPB1
                MOVF   AARGB2,W
                MOVWF   TEMPB2
                MOVF   AARGB3,W
                MOVWF   TEMPB3

                CALL 	UMUL3224L

                RETLW           0x00

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM3224A
                RRF     BARGB2,F
                BTFSC   STATUS,C
                GOTO    ALUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224A

                MOVWF   LOOPCOUNT

LOOPUM3224B
                RRF     BARGB1,F
                BTFSC   STATUS,C
                GOTO    BLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224B

                MOVWF   LOOPCOUNT

LOOPUM3224C
                RRF     BARGB0,F
                BTFSC   STATUS,C
                GOTO    CLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                CLRF    AARGB3
                RETLW   0x00
                
ALUM3224NAP     BCF     STATUS,C
                GOTO    ALUM3224NA
                
BLUM3224NAP     BCF     STATUS,C
                GOTO    BLUM3224NA
                
CLUM3224NAP     BCF     STATUS,C
                GOTO    CLUM3224NA

ALOOPUM3224
                RRF     BARGB2,F
                BTFSS   STATUS,C
                GOTO    ALUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF            TEMPB2,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB2,W
                ADDWF           AARGB2,F
                MOVF            TEMPB1,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1,F
                MOVF            TEMPB0,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0,F

ALUM3224NA
                RRF    AARGB0,F
                RRF    AARGB1,F
                RRF    AARGB2,F
                RRF             AARGB3,F
                RRF             AARGB4,F
                DECFSZ  LOOPCOUNT,F
                GOTO    ALOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM3224
                RRF     BARGB1,F
                BTFSS   STATUS,C
                GOTO    BLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF            TEMPB2,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB2,W
                ADDWF           AARGB2,F
                MOVF            TEMPB1,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1,F
                MOVF            TEMPB0,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0,F

BLUM3224NA
                RRF    AARGB0,F
                RRF    AARGB1,F
                RRF    AARGB2,F
                RRF             AARGB3,F
                RRF             AARGB4,F
                RRF             AARGB5,F
                DECFSZ  LOOPCOUNT,F
                GOTO    BLOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

CLOOPUM3224
                RRF     BARGB0,F
                BTFSS   STATUS,C
                GOTO    CLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF            TEMPB2,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB2,W
                ADDWF           AARGB2,F
                MOVF            TEMPB1,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB1,W
                ADDWF           AARGB1,F
                MOVF            TEMPB0,W
                BTFSC           STATUS,C
                INCFSZ          TEMPB0,W
                ADDWF           AARGB0,F

CLUM3224NA
                RRF    AARGB0,F
                RRF    AARGB1,F
                RRF    AARGB2,F
                RRF             AARGB3,F
                RRF             AARGB4,F
                RRF             AARGB5,F
                RRF             AARGB6,F
                DECFSZ  LOOPCOUNT,F
                GOTO    CLOOPUM3224
		RETURN	
                

	end
